// AddCard.cpp: implementation of the CAddCard class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddCard.h"
#include <afxtempl.h>
// To Do Porting : Kalpesh : 19-oct-21 : error C1083 : remove .h
#include <iostream>

#include <atlbase.h>
//WPACT-5804 : Bhabananda, Dated:16/02/2022
#include <comdef.h>
//End

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CAddCard::CAddCard(CWnd* pParent /*=NULL*/)
	: CDialog(CAddCard::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddCard)
	m_CardNo = _T("");
	m_CardStatus = _T("");
	m_cardholder = _T("");
	m_AcctName = _T("");
	m_SubAcctName = _T("");
	m_PIN1 = _T("");
	m_PIN2 = _T("");
	m_szActivationDate = _T("");
	m_szExpirationDate = _T("");
	
	//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
	m_szMLExpirationDate = _T("");//WUR 
	m_szMLActivationDate = _T("");//WUR

	m_bIsBulkCheck = FALSE;
	m_szCardNumEnd = _T("");
	m_szCardNumStart = _T("");
	m_iNXCardType = 0;
	m_nNXUsageLimit = 0;
	m_bNXLimited = FALSE;
	m_bNXTempCard = FALSE;
	m_nPRO3000CardType = 0; //Vellai - PRO3000 - HBAC API Implementation
	m_MaxAllowedAccesslevel = 0; //WPACT-5689
	m_iCardALCount = 0;
	//}}AFX_DATA_INIT
}

CAddCard ::CAddCard(IApplication *pApp):CDialog(CAddCard::IDD, NULL)
{
	m_CardNo = _T("");
	m_CardStatus = _T("");
	m_cardholder = _T("");
	m_AcctName = _T("");
	m_SubAcctName = _T("");
	m_PIN1 = _T("");
	m_PIN2 = _T("");
	m_szActivationDate = _T("");
	m_szExpirationDate = _T("");

	m_szMLExpirationDate = _T(""); //WPACT-4867
	m_szMLActivationDate = _T(""); //WPACT-4867

	m_bIsBulkCheck = FALSE;
	m_szCardNumEnd = _T("");
	m_szCardNumStart = _T("");
	m_iNXCardType = 0;
	m_nNXUsageLimit = 0;
	m_bNXLimited = FALSE;
	m_bNXTempCard = FALSE;
	m_nPRO3000CardType = 0; //Vellai - PRO3000 - HBAC API Implementation
	m_iCardALCount = 0;  //WPACT-4867
	m_bAccessTypeMulExpiry = FALSE;
	m_MaxAllowedAccesslevel = 0; //WPACT-5689
	pApplication = pApp;
	pApplication->GetAccessLevelType(&iAccessType);
	HRESULT hr = pApplication->GetAccessLevelMultipleTypeWithExpiry(&m_bAccessTypeMulExpiry);  //WPACT-4867-- Get Multiple Expiry flag --Mitesh Patel;
	if (FAILED(hr)) {
		m_bAccessTypeMulExpiry = FALSE;
	}
	CoInitialize(0);
	pCard.CreateInstance(__uuidof(Card));	
}

CAddCard ::~CAddCard()
{
	CoUninitialize();
}


/////////////////////////////////////////////////////////////////////////////
// CAddCard dialog
void CAddCard::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddCard)
	DDX_Control(pDX, IDC_NX_LIMITS, m_ctrlNXLimits);
	DDX_Control(pDX, IDC_NX_CARDTYPE, m_ctrlNXType);
	DDX_Control(pDX, IDC_CHK_NXTEMP, m_ctrlNXTemp);
	DDX_Control(pDX, IDC_CHK_NXLIMIT, m_ctrlNXLimit);
	DDX_Control(pDX, IDC_PIN1, m_ctlEditPIN1);
	DDX_Control(pDX, IDC_BULK_ADDCARD, m_ctrlBtBulkAdd);
	DDX_Control(pDX, IDADD, m_ctrlBtCardAdd);
	DDX_Control(pDX, IDC_CARD_NUMBER_END, m_ctrlCardNumEnd);
	DDX_Control(pDX, IDC_EDIT_CARD_NUMBER_START, m_ctrlCardNumStart);
	DDX_Control(pDX, IDC_EDIT_ACCESSLEVELNAME, m_ctrlAccessLevelName); //WUR
	DDX_Control(pDX, IDC_CARDNO, m_ctrlCardNumber);
	DDX_Control(pDX, IDC_MUL_ACCLLIST, m_Mul_AcclList);
	DDX_Control(pDX, IDC_STATUS, m_status);
	DDX_Control(pDX, IDC_CHID, m_ChList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AccountList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAccountList);
	DDX_Control(pDX, IDC_ACCLLIST, m_AccessList);
	DDX_Control(pDX, IDC_LIST_MLACCESSLEVEL, m_MLAccessList);  //WUR
	DDX_Text(pDX, IDC_CARDNO, m_CardNo);
	DDX_CBString(pDX, IDC_STATUS, m_CardStatus);
	DDX_CBString(pDX, IDC_CHID, m_cardholder);
	DDX_Text(pDX, IDC_ACCTNAME, m_AcctName);
	DDX_Text(pDX, IDC_SUBACCTNAME, m_SubAcctName);
	DDX_Text(pDX, IDC_PIN1, m_PIN1);
	DDX_Text(pDX, IDC_PIN2, m_PIN2);
	DDX_Text(pDX, IDC_ACTIVATIONDATE, m_szActivationDate);
	DDX_Text(pDX, IDC_EXPIRATIONDATE, m_szExpirationDate);
	DDX_Text(pDX, IDC_EDIT_EXPIRYDATE, m_szMLExpirationDate); //WUR
	DDX_Text(pDX, IDC_EDIT_ACTIVATIONDATE, m_szMLActivationDate); //WUR
	DDX_Check(pDX, IDC_CHECK_BULK_CARD_ADD, m_bIsBulkCheck);
	DDX_Text(pDX, IDC_CARD_NUMBER_END, m_szCardNumEnd);
	DDX_Text(pDX, IDC_EDIT_CARD_NUMBER_START, m_szCardNumStart);
	DDX_Text(pDX, IDC_NX_CARDTYPE, m_iNXCardType);
	DDX_Text(pDX, IDC_NX_LIMITS, m_nNXUsageLimit);
	DDX_Check(pDX, IDC_CHK_NXLIMIT, m_bNXLimited);
	DDX_Check(pDX, IDC_CHK_NXTEMP, m_bNXTempCard);
	DDX_Radio(pDX, IDC_OPT_PRO3K_CARD_STD, m_nPRO3000CardType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddCard, CDialog)
	//{{AFX_MSG_MAP(CAddCard)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDADD, OnAddCard)
	ON_BN_CLICKED(IDC_BTN_SET_EXPIRY, OnSetALInfo)
	ON_BN_CLICKED(IDC_BULK_ADDCARD, OnBulkAddcard)
	ON_BN_CLICKED(IDC_CHECK_BULK_CARD_ADD, OnCheckBulkCardAdd)
	ON_LBN_SELCHANGE(IDC_LIST_MLACCESSLEVEL, OnClickLstSelectedAccessLevel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddCard message handlers

BOOL CAddCard::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();//load the account list in WP-CS database
	
	m_status.SetCurSel(0);	
	
	if (0==iAccessType)
	{
		m_AccessList.ShowWindow(SW_SHOW);
		m_Mul_AcclList.ShowWindow(SW_HIDE);
		m_MLAccessList.ShowWindow(SW_HIDE);
	}
	if(1== iAccessType)
	{
		m_AccessList.ShowWindow(SW_HIDE);
		m_Mul_AcclList.ShowWindow(SW_SHOW);
	}
	if(m_bAccessTypeMulExpiry)   //WPACT-4867-- Show/Hide as Per flag set in DB --Mitesh Patel
	{
		m_MLAccessList.ShowWindow(SW_SHOW);
		GetDlgItem(IDC_EDIT_ACCESSLEVELNAME)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_EDIT_EXPIRYDATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL_LIST)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_ACTIVATION_DATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_EXPIRATIONDATE)->ShowWindow(SW_SHOW);	
		GetDlgItem(IDC_BTN_SET_EXPIRY)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL_GROUP)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->ShowWindow(SW_SHOW);
	}
	else
	{
		m_MLAccessList.ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_ACCESSLEVELNAME)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_EXPIRYDATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL_LIST)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_ACTIVATION_DATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_EXPIRATIONDATE)->ShowWindow(SW_HIDE);			
		GetDlgItem(IDC_BTN_SET_EXPIRY)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_ACCESSLEVEL_GROUP)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->ShowWindow(SW_SHOW);
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}

void CAddCard :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pAccount= NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount!= NULL)
			{
				//m_AccountList.AddString(pAccount->AccountName);
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AccountList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}

	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}


void CAddCard :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AccountList.GetCurSel();
		CString sAcctid;
		m_AccountList.GetLBText(index_Acct,sAcctid);
		long lAccountID = _wtoi(sAcctid);

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{
				//m_AccountList.AddString(pAccount->AccountName);
				CString sAcctid;
				sAcctid.Format(L"%ld",pSubAccount->AccountID);
				m_SubAccountList.AddString(sAcctid);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_MaxAllowedAccesslevel = 0;
	//m_AccountList.SetCurSel(0);
	
}
//WPACT-4867-- Get AccessLevelID From AccessLevel Name --Mitesh Patel
DWORD CAddCard::GetAccessLevelIDFromACName(CString stAcclName)
{
	//WPACT-5804 : Bhabananda
	DWORD dwAcclValue = 0;
	BSTR bstrAcctName = nullptr;
	BSTR bstrSubAcctName = nullptr;
	BSTR bstrAcclName = nullptr;
	LONG lCardstatus =0;
	long lAccountID=0;
	long lSubAccountID=0;

	COleSafeArray saAccessLevels;
	_bstr_t bstrAccl;
	VARIANT vAccls;
	
	int index_Acct = m_AccountList.GetCurSel();
	CString sAcctid;
	if(index_Acct >=0)
	{
		m_AccountList.GetLBText(index_Acct,sAcctid);
		lAccountID = _wtoi(sAcctid);
	}
	
	//get the Account Name by AccountID
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	int index_SubAcct = m_SubAccountList.GetCurSel();
	CString sSubAcctid;
	if(index_SubAcct >=0)
	{
		m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
		lSubAccountID = _wtoi(sSubAcctid);
	}

	//get the Account Name by AccountID
	pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);

	//select access level List

	bstrAcclName = stAcclName.AllocSysString();
	
	_variant_t vAccl;
	vAccl.Clear();
	pApplication->GetAccessLevelByName(bstrAcclName,bstrAcctName, &vAccl);

	if(vAccl.vt == VT_EMPTY)
	{
		return 0;
	}
	if( vAccl.vt & VT_DISPATCH)
	{
		long i = 0;
		saAccessLevels.CreateOneDim(VT_INT,1);
		IAccessLevelPtr pAccl(vAccl.pdispVal);
		//dwAcclValue = pAccl->AccessLevelID;
		//Added by Bhaba, Dated:02/03/2022
		long lAccesslvlId = 0;
		pAccl->get_AccessLevelID(&lAccesslvlId);
		dwAcclValue = static_cast<DWORD>(lAccesslvlId);
	}
	return dwAcclValue;

}

void CAddCard ::LoadAccessLevels()
{
		//select account name 
		//int index = m_AccountList.GetCurSel();
		//CString sAcctName;
		//m_AccountList.GetLBText(index,sAcctName);
		//BSTR bstrAcctName = sAcctName.AllocSysString();
	if(m_bAccessTypeMulExpiry)
	{
		mapStrMALAccExpiry.RemoveAll();
		CMALIDActDateMap.RemoveAll();
		CMALIDExpDateMap.RemoveAll();
		GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->SetWindowText(L"");
		GetDlgItem(IDC_EDIT_EXPIRYDATE)->SetWindowText(L"");
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(L"");
		GetDlgItem(IDC_EDIT_ACCESSLEVELNAME)->SetWindowText(L"");
	}
		//select AccountID
		int index_Acct = m_AccountList.GetCurSel();
		CString sAcctid;
		m_AccountList.GetLBText(index_Acct,sAcctid);
		long lAccountID = _wtoi(sAcctid);

		//get the Account Name by AccountID
		BSTR bstrAcctName; 
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select SubAccountID
		int index_SubAcct = m_SubAccountList.GetCurSel();
		CString sSubAcctid;
		m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
		long lSubAccountID = _wtoi(sSubAcctid);

		//get the SubAccount Name by SubAccountID
		BSTR bstrSubAcctName; 
		pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server

		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 , lBound;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
		{
			//Added by Bhaba, Dated:02/03/2022
			BSTR AccessLevelName = nullptr;
			pAccl->get_AccessLevelName(&AccessLevelName);
			//End
			if (0 == iAccessType)
				{
				//m_AccessList.AddString(pAccl->AccessLevelName);
				//Added by Bhaba, Dated:02/03/2022
				m_AccessList.AddString(AccessLevelName);
				//End
				}
				if(1 == iAccessType)
				{
				//m_Mul_AcclList.AddString(pAccl->AccessLevelName);
				//Added by Bhaba, Dated:02/03/2022
				m_Mul_AcclList.AddString(AccessLevelName);
				//End
					//WPACT-4867--Mitesh Patel					
					if(m_bAccessTypeMulExpiry)
					{
					//CString cstr = (LPCTSTR)pAccl->AccessLevelName;
					//Added by Bhaba, Dated:02/03/2022
					CString cstr = (LPCTSTR)AccessLevelName;
					//End
						DWORD dwALID = GetAccessLevelIDFromACName(cstr);
						CARD_MALINFO obj;
						
						obj.inAccessLevelID = dwALID;
						obj.ALActivationDate = (time_t)0;
						obj.ALExpirationDate = (time_t)0;
					//m_MLAccessList.AddString(pAccl->AccessLevelName);  //WUR
					//Added by Bhaba, Dated:02/03/2022
					m_MLAccessList.AddString(AccessLevelName);
					//End
						mapStrMALAccExpiry.SetAt(cstr, obj);
					}
				}
	
				pAccl->Release();
			}
			pDisp->Release();
		}
		
	//UpdateData(FALSE);
	m_AccessList.SetCurSel(0);
	//Added by Bhaba, Dated:02/03/2022
	UpdateData(FALSE);
	//End
}

void CAddCard ::LoadCardHolders()
{
	//select account name 
		//int index = m_AccountList.GetCurSel();
		//CString sAcctName;
		//m_AccountList.GetLBText(index,sAcctName);
		//BSTR bstrAcctName = sAcctName.AllocSysString();

		//select AccountID
		int index_Acct = m_AccountList.GetCurSel();
		CString sAcctid;
		m_AccountList.GetLBText(index_Acct,sAcctid);
		long lAccountID = _wtoi(sAcctid);

		//get the Account Name by AccountID
		BSTR bstrAcctName; 
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);


		//select AccountID
		int index_SubAcct = m_SubAccountList.GetCurSel();
		CString sSubAcctid;
		m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
		long lSubAccountID = _wtoi(sSubAcctid);

		//get the Account Name by AccountID
		BSTR bstrSubAcctName; 
		pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);

		_variant_t vCHs;
		vCHs.Clear();
		HRESULT hr = pApplication->GetCardHoldersByAccountName(bstrAcctName, bstrSubAcctName, &vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 , lBound;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);

		m_ChList.AddString(L"0");

		for(long i =lBound ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);

			if (pCH != NULL)
			{
				
				CString sCHid;
				sCHid.Format(L"%ld",pCH->CardHolderID);
				m_ChList.AddString(sCHid);
				
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ChList.SetCurSel(0);
}
void CAddCard::OnSelchangeAcctlist() 
{
	int index_Acct = m_AccountList.GetCurSel();
	CString sAcctid;

	m_AccountList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	//get the Account Name by AccountID
	BSTR bstrAcctName; 
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	UpdateData(TRUE);	
	m_AcctName = CString (bstrAcctName);
	UpdateData(FALSE);

	/*m_AccessList.ResetContent();
	m_Mul_AcclList.ResetContent();
	LoadAccessLevels();
	m_ChList.ResetContent();
	LoadCardHolders();*/

	m_SubAccountList.ResetContent();
	LoadSubAccounts();
	
}



void CAddCard::OnSelchangeSubAcctlist() 
{
	int index_SubAcct = m_SubAccountList.GetCurSel();
	CString sSubAcctid;

	m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
	long lSubAccountID = _wtoi(sSubAcctid);

	//get the Account Name by AccountID
	BSTR bstrSubAcctName; 
	pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);
	UpdateData(TRUE);	
	m_SubAcctName = CString (bstrSubAcctName);
	UpdateData(FALSE);

	m_AccessList.ResetContent();
	m_Mul_AcclList.ResetContent();
	m_MLAccessList.ResetContent();   //WPACT-4867 --Mitesh Patel
	LoadAccessLevels();
	m_ChList.ResetContent();
	LoadCardHolders();

}

void CAddCard::OnAddCard() 
{
	
	BSTR bstrAcctName;
	BSTR bstrSubAcctName;
	BSTR bstrAcclName;
	LONG lCardstatus;
	LONG lCardHolderID;
	BSTR bstrActivateDate;
	BSTR bstrExpireDate;
	BSTR bstrCardno;
	long lAccountID=0;
	long lSubAccountID=0;
	UpdateData(TRUE);
		
		int index_Acct = m_AccountList.GetCurSel();
		CString sAcctid;
		if(index_Acct >=0)
		{
			m_AccountList.GetLBText(index_Acct,sAcctid);
			lAccountID = _wtoi(sAcctid);
		}

		//get the Account Name by AccountID
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
			
		int index_SubAcct = m_SubAccountList.GetCurSel();
		CString sSubAcctid;
		if(index_SubAcct >=0)
		{
			m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
			lSubAccountID = _wtoi(sSubAcctid);
		}

		//get the Account Name by AccountID
		pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);

		
	//select access level List
		int index_Accl = m_AccessList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AccessList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}
	//select CardStatus
		
		long index_status =m_status.GetCurSel()+1;
		if ( index_status < 0)
		{
			AfxMessageBox(L"Select Card Status");
			return;
		}
		else
		{
			lCardstatus = index_status;
		}
	
	//card no;
	bstrCardno = m_CardNo.AllocSysString();

	//getcardholderID
		int index_CH = m_ChList.GetCurSel();
		if (index_CH <0)
		{
			lCardHolderID = 0;			
		}
		else
		{
			CString sCHid;
			m_ChList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);	
		}
		
	 //select activation Date		
		bstrActivateDate = m_szActivationDate.AllocSysString();
	//select expiration Date
		bstrExpireDate = m_szExpirationDate.AllocSysString();

	//set card properties
	//Commented by Bhaba, Dated:02/03/2022
	/*
	pCard->AccountName = bstrAcctName;
	pCard->SubAccountName = bstrSubAcctName;
	pCard->CardNumber = bstrCardno;
	*/
	//End
	//Added by Bhaba, Dated:02/03/2022
	pCard->put_AccountName(bstrAcctName);
	pCard->put_SubAccountName(bstrSubAcctName);
	pCard->put_CardNumber(bstrCardno);
	//End
		
		if(0==iAccessType)
		{
			
		//pCard->AccessLevelName = bstrAcclName;
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_AccessLevelName(bstrAcclName);
		//End
		}
		if(1== iAccessType)
		{
			// select the Access levels from access level list
			COleSafeArray saAccessLevels;
			_bstr_t bstrAccl;
			VARIANT vAccls;
			CArray<int,int> sels; //selected access level list 

			 int n = m_Mul_AcclList.GetSelCount();
			
			 if(n <= 0)
			 {
				 vAccls.vt = VT_NULL;
			 }
			else
			{
				saAccessLevels.CreateOneDim(VT_BSTR,n);
				sels.SetSize(n);
				 
				 m_Mul_AcclList.GetSelItems(n, sels.GetData());

				 //*****************************************************************************
				 // This segment of code only works if the listbox is non-owner-draw,          *
				 // or is owner-draw with LBS_HASSTRINGS                                       *
				 // So first check to make sure this is true                                   *
				 //*****************************************************************************
				 ASSERT( (GetStyle() & (LBS_OWNERDRAWFIXED | LBS_OWNERDRAWVARIABLE)) == 0 || //*
						 (GetStyle() & LBS_HASSTRINGS) == LBS_HASSTRINGS);                   //*
																							 //*
				 // Extract the text and put it to safe array;                                                        
				 for(long i = 0; i < n; i++)                                                  
				 {                                                      
					CString t;                                                              
					m_Mul_AcclList.GetText(sels[i], t);
					CARD_MALINFO ObjALInfo; //WPACT-4867--Mitesh Patel
					bstrAccl = t.AllocSysString();
					saAccessLevels.PutElement(&i,static_cast<BSTR>(bstrAccl));
				 }
				 vAccls = saAccessLevels.Detach();
				//WPACT-4867--Mitesh Patel
				 if(m_bAccessTypeMulExpiry)
				 {
					 COleSafeArray saAccessLevelsID;
					 COleSafeArray saAccessLevelsActivationD;
					 COleSafeArray saAccessLevelsExpiresD;
					 VARIANT vAcclsID;
					 VARIANT vAcclsActivationD;
					 VARIANT vAcclsExpiresD;
					 
					 saAccessLevelsID.CreateOneDim(VT_INT,n);
				   	 saAccessLevelsActivationD.CreateOneDim(VT_I4,n);
					 saAccessLevelsExpiresD.CreateOneDim(VT_I4,n);

					 for(long i = 0; i < n; i++)                                                  
					 {                                                      
						 CString t;                                                              
						 m_Mul_AcclList.GetText(sels[i], t);
						 CARD_MALINFO ObjALInfo;
						if(mapStrMALAccExpiry.Lookup(t,ObjALInfo))
						 {
							//WPACT-5804 : Bhabananda, Dated:03/03/2022
							saAccessLevelsID.PutElement(&i, &ObjALInfo.inAccessLevelID);
							saAccessLevelsActivationD.PutElement(&i, &ObjALInfo.ALActivationDate);
							saAccessLevelsExpiresD.PutElement(&i, &ObjALInfo.ALExpirationDate);
							//End
						 }	
					 }
					 
					 vAcclsID = saAccessLevelsID.Detach();
					 vAcclsActivationD = saAccessLevelsActivationD.Detach();
					 vAcclsExpiresD = saAccessLevelsExpiresD.Detach();
					 pCard->PutAccessLevelsExpiryDates(vAcclsID,vAcclsActivationD,vAcclsExpiresD);   //WPACT-4867--Store Multiple AL with Expiry Date in DB Mitesh Patel
					 
				 }
			}
		//pCard->AccessLevels = vAccls;
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_AccessLevels(vAccls);
		//End
		}
	//pCard->CardStatus = lCardstatus;
	//pCard->CardHolderID = lCardHolderID;
	//pCard->ActivationDate = bstrActivateDate;
	//pCard->ExpirationDate = bstrExpireDate;
	// 
	//Added by Bhaba, Dated:02/03/2022
	pCard->put_CardStatus(lCardstatus);
	pCard->put_CardHolderID(lCardHolderID);
	pCard->put_ActivationDate(bstrActivateDate);
	pCard->put_ExpirationDate(bstrExpireDate);
	//End

	//pCard->NetAXSCardType = m_iNXCardType;
	//pCard->NetAXSTempCard = m_bNXTempCard;
	//pCard->NetAXSLimitedCard = m_bNXLimited;
	//pCard->NetAXSUsageLimit = m_nNXUsageLimit;
	//Added by Bhaba, Dated:02/03/2022
	pCard->put_NetAXSCardType(m_iNXCardType);
	pCard->put_NetAXSTempCard(m_bNXTempCard);
	pCard->put_NetAXSLimitedCard(m_bNXLimited);
	pCard->put_NetAXSUsageLimit(m_nNXUsageLimit);
	//End

		//Vellai - PRO3000 - HBAC API Implementation
		if(m_nPRO3000CardType == 1)
		{
		//pCard->PRO3000CardType = 1;
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_PRO3000CardType(1);
		//End
		}

		//Test PIN1 Function -- Bharani -- Jun-17-08
		BSTR bstrPIN1;
	CString sPin1;
	GetDlgItem(IDC_PIN1)->GetWindowText(sPin1);
	bstrPIN1 = sPin1.AllocSysString();
	//pCard->PIN1 = bstrPIN1;
	//Added by Bhaba, Dated:02/03/2022
	pCard->put_PIN1(bstrPIN1);
	//End
		//Test PIN1 Function -- Bharani -- Jun-17-08
		BSTR bstrPIN2;
		bstrPIN2 = m_PIN2.AllocSysString();
	//Added by Bhaba, Dated:02/03/2022
	pCard->put_PIN2(bstrPIN2);
	//End
	
	//now add a card 
		long lstatus;
	HRESULT hrError;
		try
		{
		hrError = pApplication->AddCard(pCard, &lstatus);
			OutputDebugString(L"");
		}
		catch (const _com_error& ce)
		{
			CString csErr = ce.ErrorMessage();
			_bstr_t csErrDes = ce.Description();
			OutputDebugString(L"");
		}
		
		
		CString strMsg = _T("");
		strMsg.Format(_T("%d : "), lstatus);
		//get the output error values		
		if (lstatus == 101)
		{
			strMsg += _T("Card Number Exists");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 102)
		{
			strMsg += _T("Invalid Card Number");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 103)
		{
			strMsg += _T("Invalid Card Status");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 104)
		{
			strMsg += _T("Invalid Access");
			AfxMessageBox(strMsg);
			return;
		}
			if( lstatus == 105)
		{
			strMsg += _T("Invalid Account");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 108)
		{
			strMsg += _T("Invalid Card Length");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 109)
		{
			strMsg += _T("Invalid PIN Format");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 106)
		{
			strMsg += _T("Invalid Year < 1971 or > 2037");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 107)
		{
			strMsg += _T("Invalid Activation Date\n");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 110)
		{
			strMsg += _T("Invalid Access Level Type");
			AfxMessageBox(strMsg);
			return;
		}
		//The New Messages for SE/PE API -- Guru
		if (lstatus == 111)
		{
			strMsg += _T("Invalid Usage Limits");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 112)
		{
			strMsg += _T("Invalid Expiry Date");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 113)
		{
			strMsg += _T("Invalid Card Type");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 114)
		{
			strMsg += _T("Invalid Temp Card");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 115)
		{
			strMsg += _T("Invalid Limted Card");
			AfxMessageBox(strMsg);
			return;
		}
	

		if (lstatus == 1)
		{
			AfxMessageBox(L"Card Addition Failed");
			return;
		}
		if ( lstatus == 0)
		{
			AfxMessageBox(L"Card Addition Succeeded");
			CDialog::OnOK();
		}
		if (bstrAcctName)
			::SysFreeString(bstrAcctName);
		if (bstrSubAcctName)
			::SysFreeString(bstrSubAcctName);
		if (bstrAcclName)
			::SysFreeString(bstrAcclName);
		if (bstrActivateDate)
			::SysFreeString(bstrActivateDate);
		if (bstrExpireDate)
			::SysFreeString(bstrExpireDate);
	UpdateData(FALSE);
}

CString CAddCard::FormatDate(CTime time)
{
	// get time in system time format
	SYSTEMTIME st;
	time.GetAsSystemTime(st);

	// get necessary buffer size
	int nSize = GetDateFormat(
		LOCALE_SYSTEM_DEFAULT, 
		LOCALE_NOUSEROVERRIDE, 
		&st, 
		NULL, 
		NULL, 
		0);

	// format the date
	CString strDate;
	GetDateFormat(
		LOCALE_SYSTEM_DEFAULT, 
		LOCALE_NOUSEROVERRIDE, 
		&st, 
		NULL, 
		strDate.GetBuffer(nSize), 
		nSize);

	strDate.ReleaseBuffer();

	return strDate;
}

void CAddCard::OnBulkAddcard() 
{
	UpdateData(TRUE);
	BSTR bstrCardNumStart=m_szCardNumStart.AllocSysString();
	BSTR bstrCardNumEnd=m_szCardNumEnd.AllocSysString();

	///////////////////////Add card module///////////////////////
	BSTR bstrAcctName;
	BSTR bstrSubAcctName;
	BSTR bstrAcclName;
	LONG lCardstatus;
	long lAccountID=0;
	long lSubAccountID=0;

	COleSafeArray saAccessLevels;
	_bstr_t bstrAccl;
	VARIANT vAccls;
	
	int index_Acct = m_AccountList.GetCurSel();
	CString sAcctid;
	if(index_Acct >=0)
	{
		m_AccountList.GetLBText(index_Acct,sAcctid);
		lAccountID = _wtoi(sAcctid);
	}

	
	//get the Account Name by AccountID
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	int index_SubAcct = m_SubAccountList.GetCurSel();
	CString sSubAcctid;
	if(index_SubAcct >=0)
	{
		m_SubAccountList.GetLBText(index_SubAcct,sSubAcctid);
		lSubAccountID = _wtoi(sSubAcctid);
	}

	//get the Account Name by AccountID
	pApplication->GetSubAccountNameBySubAcctID(lSubAccountID,&bstrSubAcctName);

	//select access level List
	if(0==iAccessType)
	{
		int index_Accl = m_AccessList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AccessList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}

		_variant_t vAccl;
		vAccl.Clear();
		pApplication->GetAccessLevelByName(bstrAcclName,bstrAcctName, &vAccl);
		if(vAccl.vt == VT_EMPTY)
		{
			return;
		}
		if( vAccl.vt & VT_DISPATCH)
		{
			long i = 0;
			saAccessLevels.CreateOneDim(VT_INT,1);
			IAccessLevelPtr pAccl(vAccl.pdispVal);
			long lAcclID = pAccl->AccessLevelID;
			saAccessLevels.PutElement(&i,static_cast<long *>(&lAcclID));
		}
	}
	else if(1==iAccessType)
	{
		// select the Access levels from access level list
		CArray<int,int> sels; //selected access level list 

		 int n = m_Mul_AcclList.GetSelCount();
		
		 if(n <= 0)
		 {
			 vAccls.vt = VT_NULL;
		 }
		 else
		 {
			saAccessLevels.CreateOneDim(VT_INT,n);
			sels.SetSize(n);
			 
			 m_Mul_AcclList.GetSelItems(n, sels.GetData());

			 //*****************************************************************************
			 // This segment of code only works if the listbox is non-owner-draw,          *
			 // or is owner-draw with LBS_HASSTRINGS                                       *
			 // So first check to make sure this is true                                   *
			 //*****************************************************************************
			 ASSERT( (GetStyle() & (LBS_OWNERDRAWFIXED | LBS_OWNERDRAWVARIABLE)) == 0 || //*
					 (GetStyle() & LBS_HASSTRINGS) == LBS_HASSTRINGS);                   //*
																						 //*
			 // Extract the text and put it to safe array;                                                        
			 for(long i = 0; i < n; i++)                                                  
			 {                                                      
				CString sAcclName;                                                              
				m_Mul_AcclList.GetText(sels[i], sAcclName);
				bstrAccl = sAcclName.AllocSysString();
				_variant_t vAccl;
				vAccl.Clear();
				pApplication->GetAccessLevelByName(bstrAccl,bstrAcctName, &vAccl);
				if(vAccl.vt == VT_EMPTY)
				{
					return;
				}
				if( vAccl.vt & VT_DISPATCH)
				{
					IAccessLevelPtr pAccl(vAccl.pdispVal);
					long lAcclID = pAccl->AccessLevelID;
					saAccessLevels.PutElement(&i,static_cast<long *>(&lAcclID));
				}
			 }
		 }
	}

	vAccls = saAccessLevels.Detach();
	
	//select CardStatus
	long index_status =m_status.GetCurSel()+1;
	if ( index_status < 0)
	{
		AfxMessageBox(L"Select Card Status");
		return;
	}
	else
	{
		lCardstatus = index_status;
	}
	
	//select activation and Expiration Date
	COleDateTime dtActDate, dtExpDate;
	
	dtActDate.ParseDateTime(m_szActivationDate, VAR_DATEVALUEONLY, 0x0409 );
	dtExpDate.ParseDateTime(m_szExpirationDate, VAR_DATEVALUEONLY, 0x0409 );
	
	int iOperID;
	BSTR bstrOperName;

	pApplication->GetCurrentOperator(&iOperID, &bstrOperName);

	HRESULT hr = pApplication->BulkAddCards(bstrCardNumStart, bstrCardNumEnd, lAccountID, lSubAccountID, lCardstatus, dtActDate, dtExpDate, iOperID, bstrOperName, iAccessType,  vAccls);
	
	CDialog::OnOK();

}

void CAddCard::OnCheckBulkCardAdd() 
{
	UpdateData();
	if(TRUE == m_bIsBulkCheck)
	{
		m_ctrlBtBulkAdd.EnableWindow(TRUE);
		
		m_ctrlBtCardAdd.EnableWindow(FALSE);
		m_ctrlCardNumber.EnableWindow(FALSE);
		m_ctlEditPIN1.EnableWindow(FALSE);
		m_ChList.EnableWindow(FALSE);
		m_ctrlNXLimit.EnableWindow(FALSE);
		m_ctrlNXLimits.EnableWindow(FALSE);
		m_ctrlNXTemp.EnableWindow(FALSE);
		m_ctrlNXType.EnableWindow(FALSE);

		m_ctrlCardNumEnd.EnableWindow(TRUE);
		m_ctrlCardNumStart.EnableWindow(TRUE);
	}
	else
	{
		m_ctrlBtBulkAdd.EnableWindow(FALSE);

		m_ctrlBtCardAdd.EnableWindow(TRUE);
		m_ctrlCardNumber.EnableWindow(TRUE);
		m_ctlEditPIN1.EnableWindow(TRUE);
		m_ChList.EnableWindow(TRUE);
		m_ctrlNXLimit.EnableWindow(TRUE);
		m_ctrlNXLimits.EnableWindow(TRUE);
		m_ctrlNXTemp.EnableWindow(TRUE);
		m_ctrlNXType.EnableWindow(TRUE);

		m_ctrlCardNumEnd.EnableWindow(FALSE);
		m_ctrlCardNumStart.EnableWindow(FALSE);
	}
	UpdateData(FALSE);
}
//WPACT-4867--UI Changes Mitesh Patel
void CAddCard::OnClickLstSelectedAccessLevel() 
{
	int p = m_MLAccessList.GetCurSel();
	m_MLAccessList.SetCurSel(p);
	CString strAccessLevel;
	CString strActivationDate;
	CString strExpirationDate;
	m_MLAccessList.GetText(p, strAccessLevel);
	
	GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->SetWindowText(L"");
	GetDlgItem(IDC_EDIT_EXPIRYDATE)->SetWindowText(L"");

	if(strAccessLevel)
		m_ctrlAccessLevelName.SetWindowText(strAccessLevel);
	
	CARD_MALINFO ObjALInfo;
	
	DWORD dwALID = GetAccessLevelIDFromACName(strAccessLevel);		  

	if(dwALID != 0)
	{
		if(mapStrMALAccExpiry.Lookup(strAccessLevel,ObjALInfo))
		{
			CMALIDActDateMap.Lookup(dwALID,strActivationDate);
			
			CMALIDExpDateMap.Lookup(dwALID,strExpirationDate);
		
			GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->SetWindowText(strActivationDate);
			GetDlgItem(IDC_EDIT_EXPIRYDATE)->SetWindowText(strExpirationDate);
		}

	strAccessLevel.ReleaseBuffer();
	}

}

bool CAddCard::DateValidation(COleDateTime ActDate, COleDateTime ExpDate)
{

	if((ActDate.GetYear() == ExpDate.GetYear()) && (ActDate.GetMonth() == ExpDate.GetMonth()) && (ActDate.GetDay() == ExpDate.GetDay()))
	{
		return false;
	}

	CTime tAct(ActDate.GetYear(), ActDate.GetMonth(), ActDate.GetDay(), ActDate.GetHour(), ActDate.GetMinute(), ActDate.GetSecond());
	time_t dtActivationDate = tAct.GetTime( );

	CTime tExp(ExpDate.GetYear(), ExpDate.GetMonth(), ExpDate.GetDay(), ExpDate.GetHour(), ExpDate.GetMinute(), ExpDate.GetSecond());
	time_t dtExpirationDate = tExp.GetTime( );

	if((dtActivationDate > dtExpirationDate) )
	{
		return false;
	}

return true;
}

//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
void CAddCard::OnSetALInfo() 
{
	BSTR bstrMLActivateDate;
	BSTR bstrMLExpiryDate;
	CString stAccessLevelName;
	time_t dtActivationDate = 0;
	time_t dtExpirationDate  = 0;
	m_MaxAllowedAccesslevel = 0;
	GetDlgItem(IDC_EDIT_ACCESSLEVELNAME)->GetWindowText(stAccessLevelName);
	GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->GetWindowText(m_szMLActivationDate);
	GetDlgItem(IDC_EDIT_EXPIRYDATE)->GetWindowText(m_szMLExpirationDate);
	
	COleDateTime dtActDate, dtExpDate;
	CARD_MALINFO ObjALInfo;
	
	//WPACT-5689 Temp Access Assigned
	if(m_MaxAllowedAccesslevel > 1)
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Temp Access Assigned"));
	else if( m_MaxAllowedAccesslevel == 1)
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Default Access"));
	else if(m_MaxAllowedAccesslevel == 0)
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T(""));

	LPCTSTR cstrActData = (LPCTSTR)m_szMLActivationDate;
	LPCTSTR cstrExpData = (LPCTSTR)m_szMLExpirationDate;
	//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
	if(m_szMLActivationDate != "")
	{
		dtActDate.ParseDateTime(cstrActData, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);
		CTime tAct(dtActDate.GetYear(), dtActDate.GetMonth(), dtActDate.GetDay(), dtActDate.GetHour(), dtActDate.GetMinute(), dtActDate.GetSecond());
		dtActivationDate = tAct.GetTime( );

		if (dtActDate.GetMonth() == -1 )
		{
			AfxMessageBox(L"AccessLevel Activation Date is not written correctly");
			return;
		}
	}
	
	
	if(m_szMLExpirationDate != "")
	{
		dtExpDate.ParseDateTime(cstrExpData, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);
		CTime tExp(dtExpDate.GetYear(), dtExpDate.GetMonth(), dtExpDate.GetDay(), dtExpDate.GetHour(), dtExpDate.GetMinute(), dtExpDate.GetSecond());
		dtExpirationDate = tExp.GetTime();

		if (dtExpDate.GetMonth() == -1 )
		{	
			AfxMessageBox(L"AccessLevel Expiration Date is not written correctly");
			return;
		}
	}

	/*if(dtActDate == 0 && dtExpDate ==0)
	{
		AfxMessageBox(L"Please Set Activation Date");
		return;
	}*/

	if(dtActDate == 0 && dtExpDate !=0)
	{
		AfxMessageBox(L"Activation Date is required");
		return;
	}

	//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
	CTime tTmpCurrDate = CTime::GetCurrentTime().GetTime();
	CTime tTodaysDate(tTmpCurrDate.GetYear(), tTmpCurrDate.GetMonth(), tTmpCurrDate.GetDay(), 0, 0, 0, -1);
	time_t dtTodaysDate = tTodaysDate.GetTime();
	
	if ( dtActivationDate != 0 && dtActivationDate < dtTodaysDate)
	{
		AfxMessageBox(L"Activation Date must be grater than or equal to current Date");
		return;	
	}

	if (dtExpirationDate != 0 && dtExpirationDate < dtTodaysDate)
	{
		AfxMessageBox(L"Expiration Date must be grater than or equal to current Date");
		return;	
	}


	DWORD dwALID = GetAccessLevelIDFromACName(stAccessLevelName);

	if(dtExpirationDate !=0 && !DateValidation(dtActDate, dtExpDate))
	{
		AfxMessageBox(L"Expiration Date must be greater than Activation Date");
	}
	else
	{
		//CString strD;
		//strD.Format("Month: %d",dtActDate.GetMonth());
		//AfxMessageBox(strD);
	
		ObjALInfo.inAccessLevelID = dwALID;
		ObjALInfo.ALActivationDate = dtActivationDate;
		ObjALInfo.ALExpirationDate = dtExpirationDate;

		if(dwALID != 0)
		{
			if(m_MaxAllowedAccesslevel >= 8 && (dtActDate != 0 || dtExpDate !=0))
			{
				AfxMessageBox(L"Access level with Expiration has reached to Max Allowed 8");
				GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->SetWindowText(L"");
				GetDlgItem(IDC_EDIT_EXPIRYDATE)->SetWindowText(L"");
				return;		
			}//WPACT-5689
			CMALIDActDateMap.SetAt(dwALID, m_szMLActivationDate);
			CMALIDExpDateMap.SetAt(dwALID, m_szMLExpirationDate);
			mapStrMALAccExpiry.SetAt(stAccessLevelName, ObjALInfo);
			//WPACT-5689 Check Max Allowed Date for Access level with Expiration
			CARD_MALINFO ObjALDate;
			POSITION pos = mapStrMALAccExpiry.GetStartPosition();
			CString ALKey;
			m_MaxAllowedAccesslevel = 0;
			while (pos != NULL)
			{
				mapStrMALAccExpiry.GetNextAssoc(pos, ALKey, ObjALDate);
				if(ObjALDate.ALActivationDate != (time_t)0 || ObjALDate.ALActivationDate != (time_t)0)
				{
					m_MaxAllowedAccesslevel++;
				}
			}
			//WPACT-5689 Temp Access Assigned
			if(m_MaxAllowedAccesslevel > 0)
			{
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Temp Access Assigned"));
			}else
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Default Access"));
		

			//WPACT-5689 Check Max Allowed Date for Access level with Expiration
			if(m_MaxAllowedAccesslevel >= 8 && (dtActDate != 0 || dtExpDate !=0))
			{
				AfxMessageBox(L"Access level with Expiration has reached to Max Allowed 8");
				GetDlgItem(IDC_EDIT_EXPIRYDATE)->SetWindowText(L"");
				GetDlgItem(IDC_EDIT_ACTIVATIONDATE)->SetWindowText(L"");
				return;		
			}//WPACT-5689
		}
	}	
}
